
;;##########################################################################
;; systmob2.lsp
;; Copyright (c) 1991-2000 by Forrest W. Young
;; Continuation of code for ViSta system object.  
;; Code: desktop options, user preferences, configuring, 
;; installing, network admin dialogs
;;##########################################################################


;=======================
;DESKTOP OPTIONS
;=======================

(defun desktop-layout ()
  (let ((result (desktop-options-dialog))
        (nllb4 *num-listener-lines*))
    (when result
          (setf *num-listener-lines* (if (first result)
                                         (read-from-string (first result))
                                         *default-num-listener-lines*))
          (when (< *num-listener-lines* 4) (setf *num-listener-lines* 4))
          (if (not (= nllb4 *num-listener-lines*)) (restore-desktop))
          (setf *seamless-desktop*   (second result))
          (setf *thin-borders*       (third result))
          (setf *auto-type-shift*    (fourth result))
          (setf *history* nil)
          (setf *auto-activate*  nil)
          (send *workmap* :show-icon-ears? t)
          (send *workmap* :new-icon-style? t)
          (setf *drag-icon-image* nil)
          (send *vista* :workmap-proportion 1)
          (setf *default-workmap-proportion* 1)
          (send *workmap* :gui t)
          (send *vista* :workmap-size (send *workmap* :size))
          (send *vista* :workmap-location (send *workmap* :location))
          (setf *needs-desktop-resized* nil)
          (send *vista* :datasheet-size (send *datasheet* :size))
          (send *vista* :datasheet-location (send *datasheet* :location))
          (save-environment)
          (if (fifth result) (restart-vista))
          t)
    ))

(defun desktop-options-dialog ()
  (let* ((title (send text-item-proto :new (string-upcase "WORKMAP OPTIONS:")))
         (listen-text (send text-item-proto 
                            :new (format nil "Number of Listener Lines~%(minimum is 4)")))
         (listen-lines (send edit-text-item-proto :new 
                    (format nil "~d" 
                            (if (< *num-listener-lines* 4) 4 *num-listener-lines*)) 
                      :text-length 4))
         (type-to-listener (send toggle-item-proto :new "Typing Shifted to Listener?"
                     :value *auto-type-shift*))

         (window-pane-text (send  text-item-proto  :new 
                    (format nil "WINDOW PANE STYLE:~%(after restarting)")))
         (bars (send toggle-item-proto :new "Title Bars"
                     :value (not *seamless-desktop*)))
         (borders (send toggle-item-proto :new "Thin Borders"
                     :value *thin-borders*))

         (restart (send modal-button-proto :new "Restart"
                        :action #'(lambda () 
                               (list
                                (send listen-lines :text)
                                (not (send bars :value))
                                (send borders :value)
                                (send type-to-listener :value)
                                t
                                ))))
        
         (ok (send modal-button-proto :new "OK"
                   :action #'(lambda () 
                               (list
                                (send listen-lines :text)
                                (not (send bars :value))
                                (send borders :value)
                                (send type-to-listener :value)
                                nil
                                ))))
                               
         (cancel (send modal-button-proto :new "Cancel"))

         (dialog (send modal-dialog-proto 
                       :new (list 
                             (list 
                              (list title
                                    (list listen-lines listen-text)
                                    type-to-listener)
                                   
                              (list window-pane-text
                                    bars borders
                                    ))
                             (list ok cancel restart))
                       :default-button ok :title "DeskTop Options"))
         )
    (send dialog :modal-dialog)
    ))

;=======================
; PREFERENCES
;=======================

(defun screen-saver-options ()
  (let* ((text1    (send text-item-proto :new "Choose Options"))
         (toggle1  (send toggle-item-proto :new "Screen Saver On" 
                         :value (send *vista* :screen-saver-on)))
         (toggle2  (send toggle-item-proto :new "Full Screen (Not when Showing Time)"
                         :value (send *vista* :screen-saver-full-screen)))
         (choice1  (send choice-item-proto :new 
                         (list "Small Corner Clock" "Full-Screen Logo")
                         :value (send *vista* :screen-saver-clock)))
         (text2    (send text-item-proto :new (format nil "Delay~%(in Minutes)")))
         (edittext (send edit-text-item-proto 
                         :new (format nil "~a" (send *vista* :screen-saver-time))
                         :text-length 4))
         (ok    (send modal-button-proto :new "OK"
                      :action #'(lambda ()
                                  (list (send toggle1 :value)
                                        (send toggle2 :value)
                                        (send edittext :text)
                                        (send choice1 :value)
                                        ))))
         (cancel (send modal-button-proto :new "Cancel"))
       
         (dialog (send modal-dialog-proto :new
                       (list 
                        (list
                         (list (list edittext text2)
                               toggle1)
                         (list choice1
                               (list ok cancel))))
                       :title "Screen Saver Options"))
         (result (send dialog :modal-dialog))
         )
    (when result
          (send *vista* :screen-saver-on (first result))
          (if (first result)
              (send *workmap* :reset-screen-saver)
              (send *workmap* :stop-screen-saver))
          (send *vista* :screen-saver-full-screen (second result))
          (setf *screen-saver-full-screen* (second result))
          (send *vista* :screen-saver-clock (fourth result))
          (send *vista* :screen-saver-time (read-from-string (third result)))
          (send *vista* :save-prefs))
    ))

(defmeth vista-system-object-proto  :dont-show-help-panel ()
  (case (three-button-dialog (format nil "CLOSE OR REMOVE THE HELP PANEL?~2%CLOSE      - just for this session.~%REMOVE -  for this and future sessions~2%Use HELP/HELP TOPICS to see it again.") :first-button "CLOSE" :second-button "REMOVE" :third-button "CANCEL" :single-line t)
    (0 (send *help-control-panel* :close)
       (setf *help-control-panel* nil))
    (1 (send *help-control-panel* :close)
       (setf *help-control-panel* nil)
       (send self :show-welcome nil)
       (send self :show-first-help nil)
       )))

(defmeth vista-system-object-proto :new-features ()
  (file-to-window  (strcat *help-dir-name* "features.hlp") 
                   (strcat "New Features: Version " *release-number* " " *release-date*)
                   (send self :help-window-object) t nil))

(defun startup-preferences (&optional make-distribution)
  (send *vista* :preferences make-distribution))

;changes made in systmob2.lsp to fix problems in user preferences dialog
;fwy 3/16/2001

#|________________________________________________
 |
 |the following commands are relevant to startup preferences:
 | (hide-logo) (show-logo) (hide-vista) (show-vista)
 | (restart-vista) (xlisp) (vista)
 |________________________________________________
 |#

(defmeth vista-system-object-proto :preferences (&optional make-distribution)
  (let* ((in-verbosity *verbosity*)
         (text1 (send text-item-proto :new "START/EXIT PREFERENCES:"))
         (text2 (send text-item-proto :new "SESSION PREFERENCES:"))
         (text3 (send text-item-proto :new "DEVELOPER PREFERENCES"))
         (text4 (send text-item-proto :new "Verbosity Level:"))
         (text5 (send text-item-proto :new "Splash Screen Options"))
         (choice (send choice-item-proto :new 
                       (list "Hide ViSta Logo" 
                             "Spin ViSta Logo" 
                             "Show ViSta Logo")
                       :value (cond 
                                (*show-flying-logo* 1)
                                (*hide-logo* 0)
                                (t 2))))
         (choice2 (send choice-item-proto :new 
                        (list "Silent"
                              "StartUp Steps"
                              "StartUp + FileIO"
                              "Full Verbose"
                              "Full + Debug")
                        :value *verbosity*))
         (togl1 (send toggle-item-proto :new "Hide XLispStat" :value *Hide-XLispStat*))
         (togl2 (send toggle-item-proto :new "Hide DeskTop" :value *hide-desktop*))
         (togl3 (send toggle-item-proto :new "Developer Mode" :value *devel-mode*))
         (togl4 (send toggle-item-proto :new "Run Only XLispStat" :value *xlispstat-only*))
         (togl5 (send toggle-item-proto :new "Long Menus (after restart)"
                      :value (send self :show-long-menus)))
         (togl6 (send toggle-item-proto :new "Show SpinPlots Spinning"
                      :value (send self :initial-spin)))
         (togl7 (send toggle-item-proto :new "Open Data Shows Data Browser"
                      :value *show-datasheet-after-loading-data* ))
         (togl9 (send toggle-item-proto :new "Show Exit Dialog"
                      :value (send self :exit-style)))
         (togl10 (send toggle-item-proto :new "AutoShow Model Reports?"
                       :value *autoshow-model-reports*))
         (togl11 (send toggle-item-proto :new "AutoShow Model SpreadPlots?"
                       :value *autoshow-model-visuals*))
         (togl12 (send toggle-item-proto :new "Load Data Into Running ViSta?"
                       :value *load-files-with-running-vista*))
         (togl13 (send toggle-item-proto :new "Restart ViSta Now?"))
       
         (spacer0 (send text-item-proto :new " "))
         (spacer1 (send text-item-proto :new " "))
         (spacer2 (send text-item-proto :new " "))
         (spacer3 (send text-item-proto :new " "))
         (spacer4 (send text-item-proto :new " "))
         (spacer5 (send text-item-proto :new " "))
         (cancl   (send modal-button-proto :new "Cancel"))
         (help    (send modal-button-proto :new "Help"
                        :action (lambda () (preferences-dialog-help))))  
;note in following list, some items are not presented, but
;are included in list to get their value anyway so that
;everything else will work as before. Not presented because:
;screen-saver 
; - doesnt work right - keeping track of when to show
;   it next soaks up all cycles - didnt used to
;reusable and clock-to-close help windows 
; - set by help window text menu item
         (ok    (send modal-button-proto :new "OK"
                      :action #'(lambda ()
                                  (list
                                   (send choice :value) ;animate/static/hide logo 0
                                   (send togl4  :value) ;load vista   1
                                   (send togl5  :value) ;long menus   2
                                   (send togl6  :value) ;spin spinplots    3
                                   (send togl7  :value) ;load data shows datasheet 4
                                   (send togl9  :value) ;ask exit     5
                                   (send togl10 :value) ;model report 6
                                   (send togl11 :value) ;model visual 7
                                   (send togl12 :value) ;load files with running vista 8
                                   (send togl13 :value) ;restart-vista 9
                                   (send togl1  :value) ;hide XLisp window 10
                                   (send togl2  :value) ;hide DeskTop 11
                                   (send choice2 :value) ;verbosity
                                   (send togl3  :value) :devel-mode
                                   ))))
         (items (list (list 
                       (list text1 (list spacer1 togl1) 
                             (list spacer2 togl2) 
                             (list spacer3 choice) (list spacer4 togl9)
                             )
                       (list text3 togl3 text4 (list spacer0 choice2))
                       (list text2 
                             togl7 togl6 togl10 togl11 togl12 (list ok cancl)))))
         (dialog (send modal-dialog-proto :new items 
                       :title "User Preference Profile"
                       :default-button ok))
         (result (send dialog :modal-dialog)))
    (when result
          (setf *show-flying-logo* (= 1 (select result 0)))
          (setf *hide-logo* (= 0 (select result 0)))
          (if *hide-logo* (hide-logo) (show-logo))
          (msw-write-profile-string 
           "ViSta" "HideLogo" (if *hide-logo* "Yes" "No") 
           (strcat *default-path* "wxls32.ini"))
          ;previous line should be *ini-file*, but *ini-file* is nil
          (setf *show-zooming-desktop* nil)
          (send self :show-first-help nil)
          (send self :show-load-vista (select result 1))
          (setf *xlispstat-only* (select result 1))
          (msw-write-profile-string 
           "ViSta" "XLispOnly" (if *xlispstat-only* "Yes" "No") 
           (strcat *default-path* "wxls32.ini"));should be *ini-file*, but *ini-file* is nil
          (send self :show-long-menus (select result 2))
          (send self :long-menus (select result 2))
          (send self :initial-spin (select result 3))
          (setf *enable-screen-saver-feature* nil)
          (setf *enable-screen-saver-clock* nil)
          (setf *show-flying-exit-logo* nil)
          (setf *show-datasheet-after-loading-data* (select result 4))
          (send self :exit-style (select result 5))
          (setf *autoshow-model-reports* (select result 6))
          (setf *autoshow-model-visuals* (select result 7))
          (setf *load-files-with-running-vista* (select result 8))
          (setf *Hide-XLispStat* (select result 10))
          (msw-write-profile-string 
           "ViSta" "HideXLispStat" (if *Hide-XLispStat* "Yes" "No") 
           (strcat *default-path* "wxls32.ini"))
          (setf *hide-desktop* (select result 11))
          (setf *hide-vista* (select result 11))
          (msw-write-profile-string 
           "ViSta" "HideDeskTop" (if *hide-vista* "Yes" "No") 
           (strcat *default-path* "wxls32.ini"));should be *ini-file*, but *ini-file* is nil
          (when *load-files-with-running-vista*
                (warning-message "LOAD DATA INTO RUNNING VISTA may interfere with typeing in the Listeners."))
          (send *desktop-container* :title
                (strcat "ViSta - The Visual Statistics System"))
          (send *startup-manager* :idle-on *load-files-with-running-vista*)
          (when (not (= in-verbosity (select result 12)))
                (verbosity (select result 12)))
          (msw-write-profile-string 
           "XLisp" "HideMainFrame" (if (> *verbosity* 1) "No" "Yes")
           (strcat *default-path* "wxls32.ini"))
          (devel-mode (select result 13))
          (send self :save-prefs make-distribution)
          (when (select result 9) (restart-vista))
          )))

(defmeth vista-system-object-proto :save-prefs (&optional make-distribution)
  (let* ((file nil)
         (oldbreak *breakenable*))
    (setf file (open (strcat *prefs-dir-name* "prefs.lsp") :direction :output))
    (setq *breakenable* nil)
    (unwind-protect
     (cond
       (make-distribution
        (print `(send *vista* :show-flying-logo nil) file);nil=dont show startup flyer
        (print `(setf *show-flying-logo* nil) file);;;;;;;;nil=dont show startup flyer
        (print `(setf *show-zooming-desktop* nil) file) ;;;nil=dont zoom
        (print `(setf *show-flying-exit-logo* nil) file);;;nil=dont show exit flyer
        (print `(send *vista* :exit-style t) file);;;;;;;;;t=ask really exit
        (print `(send *vista* :click-to-close t) file);;;;;;;;;;;;;;;;
        (print `(send *vista* :show-first-help t) file)
        (print `(send *vista* :show-welcome t) file)
        (print `(send *vista* :show-load-vista nil) file)
        (print `(setf *xlispstat-only* nil) file)
        ;(print `(setf ask-load-vista nil) file)
        (print `(make-long-menus) file)
        (print `(send *vista* :reuse-help-windows t) file)
        (print `(send *vista* :always-on-top t) file)
        (print `(send *vista* :show-long-menus nil) file)
        (print `(send *vista* :fit-window-to-text? t) file)
        (print `(send *vista* :show-guidemap nil) file)
        (print `(send *vista* :initial-spin t) file)
        (print `(send *vista* :screen-saver-on nil) file)
        (print `(send *vista* :screen-saver-full-screen nil) file)
        (print `(send *vista* :screen-saver-time 5) file)
        (print `(send *vista* :previous-plugins ',*initial-button-names* ) file)
        (print `(setf *autoshow-model-reports* nil) file)
        (print `(setf *autoshow-model-visuals* nil) file)
        )
       (t
        (print `(send *vista* :show-flying-logo ,(send *vista* :show-flying-logo)) file)
        (print `(setf *show-flying-logo* ,*show-flying-logo*) file)
        (print `(setf *show-zooming-desktop* ,*show-zooming-desktop*) file)
        (print `(send *vista* :show-first-help ,(send *vista* :show-first-help)) file)
        (print `(send *vista* :show-welcome ,(send *vista* :show-welcome)) file)
        (print `(send *vista* :show-load-vista ,(send *vista* :show-load-vista)) file)
        
        (print `(setf *xlispstat-only* ,*xlispstat-only*) file)
        ;(print `(setf ask-load-vista ,ask-load-vista) file)
        (if (send *vista* :show-long-menus) (print `(make-long-menus) file))
        (print `(send *vista* :show-long-menus ,(send self :show-long-menus)) file)
        (print `(send *vista* :reuse-help-windows ,(send *vista* :reuse-help-windows)) file)
        (print `(send *vista* :click-to-close ,(send *vista* :click-to-close)) file)
        (print `(send *vista* :always-on-top ,(send *vista* :always-on-top)) file)
        (print `(send *vista* :fit-window-to-text? ,(send *vista* :fit-window-to-text?)) file)
        (print `(send *vista* :show-guidemap ,(send *vista* :show-guidemap)) file)
        (print `(send *vista* :initial-spin ,(send *vista* :initial-spin)) file)
        (print `(setf *show-flying-exit-logo* ,*show-flying-exit-logo*) file)
        (print `(send *vista* :screen-saver-on  ,(send *vista* :screen-saver-on) ) file)
        (print `(send *vista* :screen-saver-full-screen ,(send *vista* :screen-saver-full-screen) ) file)
        (print `(send *vista* :screen-saver-time  ,(send *vista* :screen-saver-time) ) file)
        (print `(send *vista* :exit-style ,(send *vista* :exit-style)) file)
        (print `(send *vista* :previous-plugins ',(send *vista* :previous-plugins)) file)
        (print `(setf *autoshow-model-reports* ,*autoshow-model-reports*) file)
        (print `(setf *autoshow-model-visuals* ,*autoshow-model-visuals*) file)
        ))
     (print `(send *vista* :show-open-data nil) file)
     (print `(show-toolbar) file)
     (print `(send *vista* :show-toolbar t) file)
     (print `(send *vista* :hide-workmap nil) file)
     (print `(send *vista* :show-varobs t) file)
     (print `(send *vista* :show-listener t) file)  
     (close file))
    (when *file-verbose* 
          (format t "~a~%" (strcat "; saving  " *prefs-path* "prefs.lsp")))
    (setq *breakenable* oldbreak)
    (send self :save-prefload make-distribution)
    ))


(defun  toggle-command-menu () 
  (apply #'send *command-menu* :delete-items (send *command-menu* :items))
  (install-command-menu-items))


;work done by write-prefload-file function in make-wks

(defmeth vista-system-object-proto :save-prefload (&optional make-distribution)
  (when (or make-distribution  *UPDATE-PREF-FILES* (< *run-number* 2))
        (write-prefload-file make-distribution)))

(defmeth vista-system-object-proto :update-all-pref-files (&optional make-distribution)
  (when (or *devel-mode* make-distribution  *UPDATE-PREF-FILES* (< *run-number* 2))
        (update-pref-files make-distribution)))

               



